IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[P_RC_ADM_CARTAO_MOV_BAIXA_CANCEL]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[P_RC_ADM_CARTAO_MOV_BAIXA_CANCEL]
GO
--P_RC_ADM_CARTAO_MOV_BAIXA_CANCEL 1, 22756
CREATE PROCEDURE P_RC_ADM_CARTAO_MOV_BAIXA_CANCEL @CD_EMP INT, @CD_CTR INT
AS 
SET NOCOUNT ON
DECLARE @CD_BC_LANC INT
DECLARE @CD_RAT_DESP INT
DECLARE @CD_RAT_RECTA INT
DECLARE @CD_CTR_LOTE INT
DECLARE @CD_CTR_PROC INT

SET @CD_CTR_LOTE=ISNULL((SELECT
							CD_CTR_LOTE
						FROM
							RC_ADM_CARTAO_MOV_BAIXA
						WHERE
							CD_CTR = @CD_CTR),0)
IF @CD_CTR_LOTE>0
BEGIN
		DECLARE CurLoteProc CURSOR FAST_FORWARD FOR
			SELECT
				CD_CTR
			FROM
				RC_ADM_CARTAO_MOV_BAIXA
			WHERE
				CD_CTR_LOTE = @CD_CTR_LOTE

		OPEN CurLoteProc

		FETCH NEXT FROM CurLoteProc INTO @CD_CTR_PROC

		WHILE @@FETCH_STATUS = 0
			BEGIN
				SET @CD_BC_LANC=ISNULL((SELECT
											CD_BC_LANC
									   FROM
											BC_LANC_RC_ADM_CARTAO_MOV
										where
											CD_CTR=@CD_CTR_PROC),0)

				SET @CD_RAT_DESP=ISNULL((SELECT
											CD_RAT_DESP
									   FROM
											PG_DESP_RAT_RC_ADM_CARTAO_MOV
										where
											CD_CTR=@CD_CTR_PROC),0)

				SET @CD_RAT_RECTA=ISNULL((SELECT
											CD_RAT_RECTA
									   FROM
											RC_RECTA_RAT_RC_ADM_CARTAO_MOV
										where
											CD_CTR=@CD_CTR_PROC),0)

				--Deletando movimento de lote baixa
				DELETE
				FROM
					RC_ADM_CARTAO_MOV_BAIXA
				WHERE
					CD_CTR=@CD_CTR_PROC


				--deletando vinculo bancario com o movimento de vendas
				DELETE
				FROM
					BC_LANC_RC_ADM_CARTAO_MOV
				where
					CD_CTR=@CD_CTR_PROC

				--deletando bancario
				DELETE
				FROM
					BC_LANC
				where
					CD_EMP=@CD_EMP
					AND CD_BC_LANC =@CD_BC_LANC

				--deletando vinculo de despesas
				DELETE
				FROM
					PG_DESP_RAT_RC_ADM_CARTAO_MOV
				where
					CD_CTR=@CD_CTR_PROC

				--deletando depesas
				delete
				FROM
					PG_DESP_RAT
				where
					CD_EMP = @CD_EMP
					AND CD_RAT_DESP=@CD_RAT_DESP

				--deletando vinculo com a receita
				DELETE
				FROM
					RC_RECTA_RAT_RC_ADM_CARTAO_MOV
				where
					CD_CTR=@CD_CTR_PROC

				--deletando receitas
				DELETE
				FROM
					RC_RECTA_RAT
				where
					CD_EMP = @CD_EMP
					AND CD_RAT_RECTA=@CD_RAT_RECTA

				--deletando movimento de baixa
				DELETE
				FROM
					RC_ADM_CARTAO_MOV
				where
					CD_CTR=@CD_CTR_PROC			
			FETCH NEXT FROM CurLoteProc INTO @CD_CTR_PROC
			END

		PRINT 'Concluído.'

		CLOSE CurLoteProc;

		DEALLOCATE CurLoteProc;
END
ELSE
BEGIN
	--deletando movimento de baixa
	DELETE
	FROM
		RC_ADM_CARTAO_MOV
	where
		CD_CTR=@CD_CTR		
END
